function Psi = streamlinesh( B, line_count, linestyle )
% Psi = streamlinesh( B, line_count )
% 
% Plots streamlines for a 2D mflab flow model with horizontal flow.
% B is a struct as created by the mflab readbud function
% contour_count is an optional parameter specifying the number of
% streamlines. Streamlines are created by contouring the flow function.


if nargin == 1, 
    line_count = 100; 
    linestyle = 'w-';
elseif nargin == 2,
    linestyle = 'w-';
end
   
    
termidx = find(ismember(B.label, 'FLOWRIGHTFACE')==1);

Qy = B.term{ termidx };

Psi = [ flipud( cumsum( flipud( Qy))) ; zeros( 1, size( B.term{2}, 2)) ];

plotcontours( Psi, line_count, false, linestyle )

